<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Quotes</title>
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700" rel="stylesheet" />
    <!-- Nucleo Icons -->
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet" />
    <link href="../assets/css/style.css" rel="stylesheet" />
    <link type="text/css" rel="stylesheet" href="../assets/fonts/font-awesome/css/font-awesome.min.css">
    <link href="../assets/css/nucleo-icons.css" rel="stylesheet" />
    <link href="../assets/css/nucleo-svg.css" rel="stylesheet" />
    <!-- Font Awesome Icons -->
    <link href="../assets/css/nucleo-svg.css" rel="stylesheet" />
    <!-- CSS Files -->
    <link id="pagestyle" href="../assets/css/soft-ui-dashboard.css?v=1" rel="stylesheet" />
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            font-size: 12px;
        }

        .header {
            width: 100%;
            margin-bottom: 0px;
            border-top: 1px solid #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
        }

        .company-details {
            text-align: center;
        }

        .address {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
        }

        .mail {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
        }

        .invoice-details {
            width: 100%;
            margin-bottom: 0px;
            margin-top: 0px;
        }

        .info-table {
            width: 100%;
            border-top: 1px solid #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            border-collapse: collapse;
            /* table-layout: fixed; */
        }

        .info-table td {
            width: 50%;
            padding: 8px;
            vertical-align: top;
            border-right: 1px solid #000;
        }

        .client-details {
            text-align: left;
        }

        .invoice-info {
            text-align: left;
        }

        .product-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 0px;
        }

        .product-table th,
        .product-table td {
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            padding: 3px;
            text-align: left;
        }

        .product-table tbody tr:last-child td {
            border-bottom: 1px solid #000;
        }

        .product-table th {
            background-color: #f2f2f2;
            border-top: 1px solid #000;
            border-bottom: 1px solid #000;
        }

        .footer {
            border-bottom: 1px solid #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            text-align: right;
            padding-right: 10px;
            width: 10s0%;
        }

        .col-id {
            width: 80px;
        }

        .col-description {
            width: 40%;
        }

        .col-code {
            width: 80px;
        }

        .col-qty {
            width: 80px;
        }

        .col-rate {
            width: 80px;
        }

        .col-gst {
            width: 80px;
        }

        .col-total {
            width: 90px;
        }

        .page-break {
            page-break-before: always;
        }

        .invoice-btn-section .row {
            display: flex;
            flex-wrap: nowrap;
            align-items: center;
        }

        .invoice-btn-section .btn {
            white-space: nowrap;
            margin: 0 5px;
        }

        .invoice-btn-section .form-select {
            min-width: 200px;
        }

        @media (max-width: 768px) {
            .invoice-btn-section .row {
                flex-wrap: wrap;
            }

            .invoice-btn-section .col-md-auto,
            .invoice-btn-section .col-md-3 {
                width: 100%;
                margin-bottom: 10px;
            }
        }
    </style>
</head>

<body>
    <div class="invoice-1 invoice-content">
        <div class="container">
            <div id="invoice_wrapper">
                <div class="header">
                    <div class="company-details">
                        <h3><?php echo e($addedQuote->branch->company->name); ?></h3>
                    </div>
                    <div class="address">
                        Products Quotation
                    </div>
                    <div class="mail">
                        <strong>Contact No:</strong> <?php echo e($addedQuote->branch->company->phone ?? ''); ?>

                    </div>
                </div>
                
                <div class="invoice-details">
                    <table class="info-table">
                        <tr>
                            <td class="client-details text-start">
                                <strong>To:</strong>
                                <?php echo e($addedQuote->client->user->name ?? ''); ?><br>
                                <strong>Address:</strong>
                                <?php
                                    $address = $addedQuote->client->user->location ?? '';
                                ?>
                                <?php echo e($address ?? ''); ?>

                            </td>
                            <td class="invoice-info">
                                <strong>Quote No:</strong>
                                <?php echo e($addedQuote->quote_id ?? ''); ?>

                                <br>
                                <strong>Quote Date:</strong>
                                <?php echo e($addedQuote->quote_date ?
    \Carbon\Carbon::parse($addedQuote->quote_date)->format('d-m-Y') : ''); ?>

                            </td>
                        </tr>
                    </table>
                </div>
                <table class="product-table">
                    <thead>
                        <tr>
                            <th class="col-id">S.No</th>
                            <th class="col-description">Description</th>
                            <th class="col-code">HSN Code</th>
                            <th class="col-qty">Qty</th>
                            <th class="col-rate">Rate</th>
                            
                            <th class="col-total">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $subtotal = 0;
                            $pageSubtotal = 0;
                            $pageCount = 0;               
                        ?>
                        <?php $__currentLoopData = $addedQuote->quotesItem; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $total = $product->quantity * $product->price;
                                $gstAmount = ($product->total * $product->quoteItemTaxes->sum('tax')) / 100;
                                $totalWithGst = $total + $gstAmount;
                                $subtotal += $totalWithGst;
                                $pageSubtotal += $totalWithGst;                                                                
                            ?>
                            <tr>
                                <td class="col-id"><?php echo e($index + 1); ?></td>
                                <td class="col-description">
                                    <?php echo e($settings->native_name_flag == 'A' ? ($product->product->native_name ?? $product->product_name) : ($product->product_name ?? '')); ?>

                                </td>
                                <td class="col-code">
                                    <?php echo e($product->product->hsn_code ?? ''); ?>

                                </td>
                                <td class="col-qty">
                                    <?php echo e($product->quantity ?? ''); ?>

                                </td>
                                <td class="col-rate">₹ <?php echo e(number_format($product->price ?? '', 2)); ?></td>
                                
                                <td class="col-total"><?php
                                    // $gstAmount = ($product->total * $product->quoteItemTaxes->sum('tax')) / 100;
                                    // $total = $product->total + $gstAmount;
                                    $total = $product->total;
                                ?>
                                    ₹ <?php echo e(number_format($total, 2)); ?>

                                </td>
                            </tr>

                            <?php if(($index + 1) % 18 == 0): ?>
                                    </tbody>
                                </table>
                                <div class="footer">
                                    <table class="footer-table" style="width: 100%; border-collapse: collapse;">
                                        <tr class="text-start">
                                            <td style="text-align: left;"><strong>Subtotal:</strong> </td>
                                            <td style="text-align: right;">₹ <?php echo e(number_format($pageSubtotal, 2)); ?></td>
                                        </tr>
                                        <tr class="text-start">
                                            <td style="text-align: left;"><strong>Previous Page Subtotal:</strong></td>
                                            <td style="text-align: right;">₹
                                                <?php echo e(number_format($subtotal - $pageSubtotal, 2)); ?>

                                            </td>
                                        </tr>
                                        <tr class="text-start">
                                            <td style="text-align: left;"><strong>Total:</strong></td>
                                            <td style="text-align: right;">₹ <?php echo e(number_format($subtotal, 2)); ?></td>
                                        </tr>
                                    </table>
                                </div>
                                <p style="text-align: right; margin-bottom: 30px;">...Continue</p>
                                <div class="page-break"></div>
                                <div class="header">
                                    <div class="company-details">
                                        <h3><?php echo e($addedQuote->branch->company->name); ?></h3>
                                    </div>
                                    <div class="address">
                                        <?php echo e($addedQuote->branch->company->address); ?>,
                                    </div>
                                    <div class="mail">
                                        Mail -<?php echo e($addedQuote->branch->company->email); ?>

                                    </div>
                                </div>
                                <div class="invoice-details">
                                    <table class="info-table">
                                        <tr>
                                            <td class="client-details text-start">
                                                <strong>GST No -</strong>
                                                <?php echo e($addedQuote->branch->gst_no ?? ''); ?><br>
                                            </td>
                                            <td class="invoice-info">
                                                <strong>Contact No:</strong> <?php echo e($addedQuote->branch->company->phone ?? ''); ?><br>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="invoice-details">
                                    <table class="info-table">
                                        <tr>
                                            <td class="client-details text-start">
                                                <strong>To:</strong>
                                                <?php echo e($addedQuote->client->user->name ?? ''); ?><br>
                                                <strong>Address:</strong>
                                                <?php echo e($address ?? ''); ?>

                                            </td>
                                            <td class="invoice-info">
                                                <strong>Payment Terms:</strong>
                                                <?php echo e($addedQuote->due_date ? \Carbon\Carbon::parse($addedQuote->due_date)->format('d-m-Y') : ''); ?><br>
                                                <strong>Bill No:</strong>
                                                <?php echo e($addedQuote->invoice_id ?? ''); ?>

                                                <br>
                                                <strong>Date:</strong>
                                                <?php echo e($addedQuote->invoice_date ? \Carbon\Carbon::parse($addedQuote->invoice_date)->format('d-m-Y') : ''); ?>

                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <table class="product-table">
                                    <thead>
                                        <tr>
                                            <th class="col-id">S.No</th>
                                            <th class="col-description">Description</th>
                                            <th class="col-code">HSN Code</th>
                                            <th class="col-qty">Qty</th>
                                            <th class="col-rate">Rate</th>
                                            <th class="col-gst">GST(%)</th>
                                            <th class="col-total">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            $pageSubtotal = 0;
                                            $pageCount++;
                                        ?>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> </tbody>
                </table>
                <div class="footer">
                    <table class="footer-table" style="width: 100%; border-collapse: collapse;">
                        <tr>
                            <td style="text-align:left"> <strong>Subtotal:</strong></td>
                            <td style="text-align:right;">₹ <?php echo e(number_format($pageSubtotal, 2)); ?></td>
                        </tr>
                        <tr>
                            <td style="text-align:left"> <strong>Previous Page Subtotal:</strong></td>
                            <td style="text-align:right;">₹
                                <?php echo e(number_format($subtotal - $pageSubtotal, 2)); ?>

                            </td>
                        </tr>
                        <tr>
                            <td style="text-align:left"> <strong>Total:</strong></td>
                            <td style="text-align:right;">₹ <?php echo e(number_format($subtotal, 2)); ?></td>
                        </tr>
                        
                        <?php if($settings->signature_flag == 'A'): ?>
                            <tr>
                                <td colspan="2" style="padding-top: 20px; text-align: right;">
                                    <!-- Signature Line (for authorized person) -->
                                    <div
                                        style="border-top: 1px dashed #000; width: 100%; padding-top: 5px; margin-left: auto;">
                                        <strong>Authorized Signature</strong>
                                    </div>

                                    <!-- Space for actual signing (empty space) -->
                                    <div style="height: 30px;"></div>

                                    <!-- Company and branch details -->
                                    <div style="margin-top: 10px;">
                                        <strong><?php echo e($settings->company->name ?? ''); ?>,</strong><br>
                                        <span style="font-size: 0.9em;"><?php echo e($settings->name ?? 'Head Office'); ?>.</span>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </table>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="invoice-inner clearfix">
                        <div class="invoice-btn-section clearfix d-print-none">
                            <div class="row align-items-center gx-2 gy-2 mt-0">
                                <div class="col-md-3">
                                    <select name="paper_size" id="paper_size" class="form-select">
                                        <option value="">Select Standard paper size</option>
                                        <?php $__currentLoopData = $paper; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-auto">
                                    <a href="#" class="btn" id="print_btn">
                                        <i class="fa fa-print"></i> Print Quotes
                                    </a>
                                </div>
                                <div class="col-md-auto">
                                    <a id="invoice_download_btn" class="btn">
                                        <i class="fa fa-download"></i> Download Quotes
                                    </a>
                                </div>
                                <div class="col-md-auto">
                                    <a href='<?php echo e(route('quotes-index')); ?>' id="cancel-btn" class="btn">
                                        <i class="fa fa-arrow-left"></i> Back
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="<?php echo e(asset('assets/js/core/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/core/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/smooth-scrollbar.min.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/jspdf.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/html2canvas.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/app.js')); ?>"></script>
    <script>
        $(function () {

            'use strict';

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $(document).on('click', '#invoice_download_btn', function () {
                var formData = new FormData();
                formData.append("quote_id", "<?php echo e($addedQuote->id); ?>");
                formData.append("type", "download");

                $.ajax({
                    url: '<?php echo e(route('show-quote-pdf')); ?>',
                    method: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    xhrFields: {
                        responseType: 'blob'
                    },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function (response) {
                        var link = document.createElement('a');
                        var blob = response;
                        var url = window.URL.createObjectURL(blob);
                        link.href = url;
                        link.download = "<?php echo e($addedQuote->invoice_id); ?>.pdf";
                        link.click();
                        window.URL.revokeObjectURL(url);
                    },
                    error: function (error) {
                        console.log("Error saving the file:", error);
                    }
                });
            });
            $(document).on('click', '#print_btn', function () {
                var formData = new FormData();
                formData.append("quote_id", "<?php echo e($addedQuote->id); ?>");
                formData.append("type", "print");

                $.ajax({
                    url: '<?php echo e(route('show-quote-pdf')); ?>',
                    method: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    xhrFields: {
                        responseType: 'blob'
                    },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') // Include CSRF token in the request header
                    },
                    success: function (response) {
                        var blob = response;
                        var url = window.URL.createObjectURL(blob);
                        var printWindow = window.open(url, '_blank');
                        printWindow.onload = function () {
                            printWindow.print();
                        };
                    },
                    error: function (error) {
                        console.log("Error saving the file:", error);
                    }
                });
            });
        });
    </script>
    <script>
        $(function () {
            $(document).on('change', '#paper_size', function () {
                const paperId = $('#paper_size').val();
                const invoiceId = "<?php echo e($addedQuote->id); ?>";

                window.location.href = "<?php echo e(route('quote-pdf', ['id' => 'INVOICE_ID_PLACEHOLDER'])); ?>".replace('INVOICE_ID_PLACEHOLDER', invoiceId) + "?paperId=" + paperId;
            });
        });
    </script>
</body>

</html><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/quotes/pdf/quote-generate-pdf.blade.php ENDPATH**/ ?>