

<?php $__env->startSection('content'); ?>

    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <!-- Card Header -->
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">All Branches</h5>
                            </div>
                            <a href="<?php echo e(route('branch-add')); ?>" class="btn bg-gradient-primary btn-sm mb-0"
                                type="button">+&nbsp;
                                New Branch</a>
                        </div>
                    </div>

                    <!-- Card Body -->
                    <div class="card-body px-0 pt-0 pb-2">
                        

                        <div class="table-responsive p-0">
                            <table class="table align-items-center mb-0 table-hover" id="myTable1">
                                <thead>
                                    <tr>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Company Name
                                        </th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Branch Name
                                        </th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            logo
                                        </th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Phone
                                        </th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Email
                                        </th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Address
                                        </th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Actions
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0"><?php echo e($data->company_name ?? ''); ?></p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0"><?php echo e($data->name ?? ''); ?></p>
                                            </td>
                                            <td class="ps-4">
                                                <?php if($data->logo): ?>
                                                    <img src="<?php echo e(getFileUrl($data->logo)); ?>" alt="Image Preview" class="img-fluid"
                                                        style="width: 50px; height: 50px; object-fit: cover;">
                                                <?php else: ?>
                                                    <img src="<?php echo e(asset('assets/img/logos/product.png' . $data->logo)); ?>"
                                                        alt="Image Preview" class="img-fluid"
                                                        style="width: 50px; height: 50px; object-fit: cover;">
                                                <?php endif; ?>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0"><?php echo e($data->phone ?? ''); ?></p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0"><?php echo e($data->email ?? ''); ?></p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0"><?php echo e($data->address ?? ''); ?></p>
                                            </td>
                                            <td>
                                                <!-- Edit Icon -->
                                                <a href="<?php echo e(route('branch-edit', ['id' => $data->id])); ?>"
                                                    data-bs-toggle="tooltip" data-bs-original-title="Edit Branch">
                                                    <i class="fa-solid fa-pen-to-square text-secondary"></i>
                                                </a>
                                                <span class="ms-2">
                                                    <!-- Delete Icon and Form -->
                                                    <form action="<?php echo e(route('branch-delete', ['id' => $data->id])); ?>"
                                                        class="d-inline" method="POST" id="delete-form-<?php echo e($data->id); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <i class="cursor-pointer fas fa-trash text-secondary"
                                                            onclick="confirmDelete(<?php echo e($data->id); ?>)"></i>

                                                    </form>
                                                </span>
                                            </td>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="7" class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">No branches found.</p>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
    </script>
    <script>
        $('#myTable1').DataTable();
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/branch/index.blade.php ENDPATH**/ ?>