<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\BranchModel;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class MobAuthController extends Controller
{
    public function login(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'password' => 'required'
        ]);

        if (!Auth::attempt($request->only('email', 'password'))) {
            return response()->json(['message' => 'Invalid login credentials'], 401);
        }

        $user = Auth::user();
        $token = $user->createToken('mobile-app-token')->plainTextToken;
        return response()->json([
            'user' => $user,
            'token' => $token
        ]);
    }

    public function getCompanies()
    {
        $user = Auth::user();
        $companies = $user->companies;

        return response()->json([
            'status' => true,
            'companies' => $companies,
        ]);
    }
    public function getBranches($id)
    {
        $user = Auth::user();
        $companyId = $id;

        if ($user->companies->contains('id', $companyId)) {
            $branches = BranchModel::where('company_id', $companyId)
                ->whereHas('users', function ($query) use ($user) {
                    $query->where('user_id', $user->id);
                })
                ->get();

            return response()->json(['branches' => $branches]);
        }

        return response()->json(['branches' => []]);
    }

    public function setup(Request $request)
    {

        $request->validate([
            'company_id' => 'required|integer',
            'branch_id' => 'required|integer',
        ]);

        $user = $request->user();
        $companyId = $request->input('company_id');
        $branchId = $request->input('branch_id');

        if (
            !$user->companies->contains('id', $companyId) ||
            !BranchModel::where('id', $branchId)
                ->where('company_id', $companyId)
                ->whereHas('users', function ($query) use ($user) {
                    $query->where('user_id', $user->id);
                })->exists()
        ) {
            return response()->json([
                'success' => false,
                'message' => 'Invalid company or branch selection',
            ], 422);
        }


        return response()->json([
            'success' => true,
            'message' => 'Setup successful',
            'data' => [
                'company_id' => $companyId,
                'branch_id' => $branchId,
            ],
        ]);
    }


}
